
Type TPhysicsSimulatorView
	Field _physicsSimulator:TPhysicsSimulator
	
	'aabb
	Field _aabbColor:TColor = TColor.Create(150, 0, 0, 0) 
	Field _aabbLineThickness:Int = 1
	Field _aabbLineBrush:TLineBrush
	Field _enableAABBView:Int = True
	
	
	'vertices
	Field _verticeRadius:Int = 3
	Field _verticeColor:TColor = TColor.Create(150, 0, 50, 0) 
	Field _verticeCircleBrush:TCircleBrush
	Field _enableVerticeView:Int = True
	
	'edges
	Field _edgeLineThickness:Int = 1
	Field _edgeColor:TColor = TColor.Create(150, 0, 0, 0) 
	Field _edgeLineBrush:TLineBrush
	Field _enableEdgeView:Int = True
	
	'grid
	Field _gridradius:Int = 1
	Field _gridColor:TColor = TColor.Create(150, 0, 0, 0) 
	Field _gridCircleBrush:TCircleBrush
	Field _enableGridView:Int = False
	
	'coordinate axis
	Field _coordinateAxisColor:TColor = TColor.Create(150, 0, 0, 0) 
	Field _coordinateAxisLineThickness:Int = 1
	Field _coordinateAxisLineLength:Int = 20
	Field _coordinateAxisLineBrush:TLineBrush
	Field _enableCoordinateAxisView:Int = True
	
	'contacts
	Field _contactColor:TColor = TColor.Create(150, 255, 0, 0) 
	Field _contactRadius:Int = 4
	Field _contactCircleBrush:TCircleBrush
	Field _enableContactView:Int = True
	
	'revolute joint
	Field _revoluteJointColor:TColor = TColor.Create(200, 0, 0, 0)
	Field _revoluteJointLineThickness:Int = 1
	Field _revoluteJointLineBrush:TLineBrush
	Field _revoluteJointRectangleBrush:TRectangleBrush
	Field _enableRevoluteJointView:Int = True
	
	'pin joint
	Field _pinJointColor:TColor = TColor.Create(200, 0, 0, 0)
	Field _pinJointLineThickness:Int = 1
	Field _pinJointLineBrush:TLineBrush
	Field _pinJointRectangleBrush:TRectangleBrush
	Field _enablePinJointView:Int = True
	
	' slider joint
	Field _sliderJointColor:TColor = TColor.Create(200, 0, 0, 0)
	Field _sliderJointLineThickness:Int = 1
	Field _sliderJointLineBrush:TLineBrush
	Field _sliderJointRectangleBrush:TRectangleBrush
	Field _enableSliderJointView:Int = True
	
	'springs
	Field _springLineColor:TColor = TColor.Create(150, 0, 0, 0)
	Field _springLineThickness:Int = 1
	Field _springLineBrush:TLineBrush
	Field _springCircleBrush:TCircleBrush
	Field _enableSpringView:Int = True
	'------
	
	'performance panel
	Field _performancePanelColor:TColor = TColor.Create(150, 0, 0, 0) 
	Field _performancePanelTextColor:TColor = TColor.Black
	Field _performancePanelTexture:TImage
	Field _enablePerformancePanelView:Int = True
	Field _performancePanelPosition:Vector2 = Vector2.Create(100, 110) 
	Field _performancePanelWidth:Int = 220
	Field _performancePanelHeight:Int = 150
	Field _updateTotal:String = "Update Total: "
	Field _cleanUp:String = "Clean Up: "
	Field _broadPhaseCollision:String = "Broad Phase Collision: "
	Field _narrowPhaseCollision:String = "Narrow Phase Collision: "
	Field _applyForces:String = "Apply Forces: "
	Field _applyImpulses:String = "Apply Impulses: "
	Field _updatePosition:String = "Update Positions: "
	
	Function Create:TPhysicsSimulatorView(physics:TPhysicsSimulator) 
		Local view:TPhysicsSimulatorView = New TPhysicsSimulatorView
		view._physicsSimulator = physics
		view.Load() 
		Return view
	End Function
	
	'#Region Getters/setters for AABB
	Method GetAABBColor:TColor()
		Return Self._aabbColor
	End Method
	
	Method SetAABBColor(value:TColor)
		_aabbColor = value
	End Method
	
	Method GetAABBLineThickness:Int()
		Return _aabbLineThickness
	End Method
	
	Method SetAABBLineThickness(value:Int)
		_aabbLineThickness = value
	End Method
	
	Method EnableAABBView(value:Int)
		_enableAABBView = value
	End Method	
	'#End Region
	
	'#Region Getters/setters for vertices
	Method GetVerticeRadius:Int()
		Return _verticeRadius
	End Method
	
	Method SetVerticesRadius(value:Int)
		_verticeRadius = value
	End Method
	
	Method SetVerticeColor(value:TColor)
		_verticeColor = value
	End Method
	
	Method GetVerticeColor:TColor()
		Return _verticeColor
	End Method
	
	Method EnableVerticeView(value:Int)
		_enableVerticeView = value
	End Method
	'#End Region
	
	'#Region Getter/setters for edges
	Method GetEdgeLineThickness:Int()
		Return _edgeLineThickness
	End Method
	
	Method SetEdgeLineThickness(value:Int)
		_edgeLineThickness = value
	End Method
	
	Method GetEdgeColor:TColor()
		Return _edgeColor
	End Method
	
	Method SetEdgeColor(value:TColor)
		_edgeColor = value
	End Method
	
	Method EnableEdgeView(value:Int)
		_enableEdgeView = value
	End Method
	'#End Region
	
	
	'#Region Getter/setters for grid
	Method GetGridRadius:Int()
		Return _gridRadius
	End Method
	
	Method SetGridRadius(value:Int)
		_gridRadius = value
	End Method
	
	Method GetGridColor:TColor()
		Return _gridColor
	End Method
	
	Method SetGridColor(value:TColor)
		_gridColor = value
	End Method
	
	Method EnableGridView(value:Int)
		_enableGridView = value
	End Method
	'#End Region
	
	'#Region Getters/setters coordinate axis
	Method GetCoordinateAxisLineThickness:Int()
		Return _coordinateAxisLineThickness
	End Method
	
	Method SetCoordinateAxisLineThickness(value:Int)
		_coordinateAxisLineThickness = value
	End Method
	
	Method GetCoordinateAxisColor:TColor()
		Return _coordinateAxisColor
	End Method
	
	Method SetCoordinateAxisColor(value:TColor)
		_coordinateAxisColor = value
	End Method
	
	Method GetCoordinateAxisLineLength:Int()
		Return _coordinateAxisLineLength
	End Method
	
	Method SetCoordinateAxisLineLength(value:Int)
		_coordinateAxisLineLength = value
	End Method
	
	Method EnableCoordinateAxisView(value:Int)
		_enableCoordinateAxisView = value
	End Method
	'#End Region
	
	'#Region getter/setters contacts
	Method GetContactRadius:Int()
		Return _contactRadius
	End Method
	
	Method SetContactRadius(value:Int)
		_contactRadius = value
	End Method
	
	Method EnableContactView(value:Int)
		_contactRadius = value
	End Method
	'#End Region
	
	'#Region getter/setters springs
	Method GetSpringLineColor:TColor()
		Return _springLineColor
	End Method
	
	Method SetSpringLineColor(value:TColor)
		_springLineColor = value
	End Method
	
	Method GetSpringLineThickness:Int()
		Return _springLineThickness
	End Method
	
	Method SetSpringLineThickness(value:Int)
		_springLineThickness = value
	End Method
	
	Method EnableSpringView(value:Int)
		_enableSpringView = value
	End Method
	'#End Region
	
	'#Region getter/setters revolute joint
	Method GetRevoluteJointLineColor:TColor()
		Return Self._revoluteJointColor
	End Method
	
	Method SetRevoluteJointLineColor(value:TColor)
		_revoluteJointColor = value
	End Method
	
	Method GetRevoluteJointLineThickness:Int()
		Return _revoluteJointLineThickness
	End Method
	
	Method SetRevoluteJointLineThickness(value:Int)
		_revoluteJointLineThickness = value
	End Method
	
	Method EnableRevoluteJointView(value:Int)
		_enableRevoluteJointView = value
	End Method
	'#End Region
	
	'#Region getter/setters pin joint
	Method GetPintJointLineColor:TColor()
		Return _pinJointColor
	End Method
	
	Method SetPinJointLineColor(value:TColor)
		_pinJointColor = value
	End Method
	
	Method GetPinJointLineThickness:Int()
		Return _pinJointLineThickness
	End Method
	
	Method SetPinJointLineThickness(value:Int)
		_pinJointLineThickness = value
	End Method
	
	Method EnablePinJointView(value:Int)
		_enablePinJointView = value
	End Method
	'#End Region
	
	'#Region getter/setter slider joint
	Method GetSliderJointLineColor:TColor()
		Return _sliderJointColor
	End Method
	
	Method SetSliderJointLineColor(value:TColor)
		_sliderJointColor = value
	End Method
	
	Method GetSliderJointLineThickness:Int()
		Return _sliderJointLineThickness
	End Method
	
	Method SetSliderJointLineThickness(value:Int)
		_sliderJointLineThickness = value
	End Method
	
	Method EnableSliderJointView(value:Int)
		_enableSliderJointView = value
	End Method
	'#End Region
	
	'#Region getter/setters performance panel
	Method GetPerformancePanelColor:TColor()
		Return _performancePanelColor
	End Method
	
	Method SetPerformancePanelColor(value:TColor)
		_performancePanelColor = value
	End Method
	
	Method GetPerformancePanelTextcolor:TColor()
		Return _performancePanelTextcolor
	End Method
	
	Method SetPerformancePanelTextColor(value:TColor)
		_performancePanelTextColor = value
	End Method
	
	Method EnablePerformancePanelView(value:Int)
		_enablePerformancePanelView = value
	End Method
	'#End Region
	
	
'#Region Load
	Method Load() 
		LoadVerticeContent() 
		LoadEdgeContent() 
		LoadGridContent() 
		LoadAABBContent() 
		LoadCoordinateAxisContent() 
		LoadContactContent() 
		LoadPerformancePanelContent()
		LoadSpringContent()
		LoadRevoluteJointContent()
		LoadPinJointContent()
		LoadSliderJointContent()
	End Method
	
	Method LoadSliderJointContent()
		_sliderJointLineBrush = TLineBrush.Create(_sliderJointLineThickness, _sliderJointColor)
		_sliderJOintRectangleBrush = TRectangleBrush.Create(10, 10, _sliderJointColor, _sliderJointColor)		
	End Method
	
	Method LoadPinJointContent()
		_pinJointLineBrush = TLineBrush.Create(_pinJointLineThickness, _pinJointColor)
		_pinJointRectangleBrush = TRectangleBrush.Create(10, 10, _pinJointColor, _pinJointColor)		
	End Method
	
	Method LoadRevoluteJointContent()
		_revoluteJointLineBrush = TLineBrush.Create(_revoluteJointLineThickness, _revoluteJointColor)
		_revoluteJointRectangleBrush = TRectangleBrush.Create(10, 10, _revoluteJointColor, _revoluteJointColor)				
	End Method
	
	Method LoadSpringContent()
		_springLIneBrush = TLineBrush.Create(_springLineThickness, _springLineColor)
		_springCircleBrush = TCircleBrush.Create(2, _springLineColor, _springLineColor)			
	End Method
	
	Method LoadVerticeContent() 
		Self._verticeCircleBrush = TCircleBrush.Create(_verticeRadius, _verticeColor, _verticeColor) 
	End Method
	
	Method LoadEdgeContent() 
		Self._edgeLineBrush = TLineBrush.Create(_edgeLineThickness, _edgeColor) 		
	End Method
	
	Method LoadGridContent() 
		Self._gridCircleBrush = TCircleBrush.Create(_gridRadius, _gridColor, _gridColor) 		
	End Method
	
	Method LoadAABBContent() 
		Self._aabbLineBrush = TLineBrush.Create(_aabblineThickness, _aabbColor) 		
	End Method
	
	Method LoadCoordinateAxisContent() 
		Self._coordinateAxisLineBrush = TLineBrush.Create(_coordinateAxisLineThickness, _coordinateAxisColor) 		
	End Method
	
	Method LoadContactContent() 
		Self._contactCircleBrush = TCircleBrush.Create(_contactRadius, _contactColor, _contactColor) 
	End Method
	
	Method LoadPerformancePanelContent() 
		_performancePanelTexture = TDrawingHelper.CreateRectangleTexture(_performancePanelWidth, _performancePanelHeight, Self._performancePanelColor, Self._performancePanelColor) 
	End Method
'#End Region 

'#Region Draw
	Method Draw() 
		If _enableVerticeView Or _enableEdgeView Then DrawVerticesAndEdges() 
		If _enableGridView Then DrawGrid()
		If _enableAABBView Then DrawAABB() 
		If _enableCoordinateAxisView Then DrawCoordinateAxis()
		If _enableContactView Then DrawContacts()
		If _enableSpringView Then DrawSprings()
		If _enableRevoluteJointView Then DrawRevoluteJoints()
		If _enablePinJointView Then DrawPinJoints()
		If _enableSliderJointView Then DrawSliderJoints()
		If _enablePerformancePanelView Then DrawPerformancePanel()
	End Method
	
	Method DrawSliderJoints()
		Local jointlist:TJointList = _physicsSimulator.GetJointList()
		For Local slider:TSliderJoint = EachIn jointList
			_sliderJointRectangleBrush.Draw(slider.GetWorldAnchor1())
			_sliderJointRectangleBrush.Draw(slider.GetWorldAnchor2())
			_sliderJointLineBrush.Draw(slider.GetWorldAnchor1(), slider.GetWorldAnchor2())			
		Next
	End Method
	
	Method DrawPinJoints()
		Local jointList:TJointList = _physicsSimulator.GetJointList()
		For Local joint:TPinJoint = EachIn jointList			
			_pinJointRectangleBrush.Draw(joint.GetWorldAnchor1())
			_pinJointRectangleBrush.Draw(joint.GetWorldAnchor2())
			_pinJointLineBrush.Draw(joint.GetWorldAnchor1(), joint.GetWorldAnchor2())
		Next
	End Method
	
	Method DrawRevoluteJoints()
		Local jointList:TJointList = _physicsSimulator.GetJointList()
		For Local joint:TJoint = EachIn jointList
			If TFixedRevoluteJoint(joint) Then
				Local rev:TFixedRevoluteJoint = TFixedRevoluteJoint(joint)
				_revoluteJointRectangleBrush.Draw(rev._anchor)
			Else If TRevoluteJoint(joint) Then
				Local rev:TRevoluteJoint = TRevoluteJoint(joint) 
				_revoluteJointRectangleBrush.Draw(rev.GetCurrentAnchor()) 
				_revoluteJointLineBrush.Draw(rev.GetCurrentAnchor(), rev._body1._position) 
				_revoluteJointLineBrush.Draw(rev.GetCurrentAnchor(), rev._body2._position) 
			End If
		Next
	End Method
	
	Field _body1AttachPointInWorldCoordinates:Vector2 = Vector2.Zero()
	Field _body2AttachPointInWorldCoordinates:Vector2 = Vector2.Zero()
	Field _vectorTemp1:Vector2 = Vector2.Zero()
	Field _worldAttachPoint:Vector2 = Vector2.Zero()
	Field _attachPoint1:Vector2 = Vector2.Zero()
	Field _attachPoint2:Vector2 = Vector2.Zero()
	Method DrawSprings()
			Local cList:TControllerList = _physicsSimulator.GetControllerList()
			For Local controller:TController = EachIn clist
				If TFixedLinearSpring(controller) Then
					Local fixed:TFixedLinearSpring = TFixedLinearSpring(controller)
					_worldAttachPoint.X = fixed._worldAttachPoint.X
					_worldAttachPoint.Y = fixed._worldAttachPoint.Y
					fixed._body.GetWorldPositionRef(fixed._bodyAttachPoint, _body1AttachPointInWorldCoordinates)
					_springCircleBrush.Draw(_body1AttachPointInWorldCoordinates)
					_springCircleBrush.Draw(_worldAttachPoint)
					
					Vector2.LerpRef(_worldAttachPoint, _body1AttachPointInWorldCoordinates, .25, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					Vector2.LerpRef(_worldAttachPoint, _body1AttachPointInWorldCoordinates, .50, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					Vector2.LerpRef(_worldAttachPoint, _body1AttachPointInWorldCoordinates, .75, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					_springLineBrush.Draw(_body1AttachPointInWorldCoordinates, fixed._worldAttachPoint)
				Else If TLinearSpring(controller) Then
					Local linear:TLinearSpring = TLinearSpring(controller)
					_attachPoint1 = linear._attachPoint1
					_attachPoint2 = linear._attachPoint2
					linear._body1.GetWorldPositionRef(_attachPoint1, _body1AttachPointInWorldCoordinates)
					linear._body2.GetWorldPositionRef(_attachPoint2, _body2AttachPointInWorldCoordinates)
					_springCircleBrush.Draw(_body1AttachPointInWorldCoordinates)
					_springCircleBrush.Draw(_body2AttachPointInWorldCoordinates)
					
					Vector2.LerpRef(_body1AttachPointInWorldCoordinates, _body2AttachPointInWorldCoordinates, .25, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					Vector2.LerpRef(_body1AttachPointInWorldCoordinates, _body2AttachPointInWorldCoordinates, .50, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					Vector2.LerpRef(_body1AttachPointInWorldCoordinates, _body2AttachPointInWorldCoordinates, .75, _vectorTemp1)
					_springCircleBrush.Draw(_vectorTemp1)
					
					_springLineBrush.Draw(_body1AttachPointInWorldCoordinates, _body2AttachPointInWorldCoordinates)
				End If
			Next
	End Method
	
	Method DrawVerticesAndEdges() 
		Local verticeCount:Int
		Local geomList:TGeomList = _physicsSimulator.GetGeomList() 
		For Local geom:TGeom = EachIn geomList
			verticeCount = geom._localVertices.Count() 
			For Local j:Int = 0 To verticeCount - 1
				If _enableEdgeView Then
					If j < verticeCount - 1 Then
						_edgeLineBrush.Draw(geom._worldVertices._vecArray[j] , geom._worldVertices._vecArray[j + 1] ) 
					Else
						_edgeLineBrush.Draw(geom._worldVertices._vecArray[j] , geom._worldVertices._vecArray[0] ) 
					End If
				End If
				If _enableVerticeView Then
					_verticeCircleBrush.Draw(geom._worldVertices._vecArray[j] ) 
				End If
			Next
		Next
	End Method
	
	Method DrawAABB() 
		Local minv:Vector2
		Local maxv:Vector2
		
		Local topRight:Vector2
		Local bottomLeft:Vector2
		
		Local geomList:TGeomList = _physicsSimulator.GetGeomList() 
		For Local geom:TGeom = EachIn geomList
			minv = geom._aabb._min
			maxv = geom._aabb._max
			
			topRight = Vector2.Create(maxv.X, minv.Y) 
			bottomLeft = Vector2.Create(minv.X, maxv.Y) 
			_aabbLineBrush.Draw(minv, topright) 
			_aabbLineBrush.Draw(topright, maxv) 
			_aabbLineBrush.Draw(maxv, bottomLeft) 
			_aabbLineBrush.Draw(bottomLeft, minv) 
		Next
	End Method
	
	Method DrawCoordinateAxis() 
		Local bodyList:TBodyList = _physicsSimulator.GetBodyList() 
		For Local body:TBody = EachIn bodyList
			Local startX:Vector2 = body.GetWorldPosition(Vector2.Create(- _coordinateAxisLineLength / 2, 0)) 
			Local endX:Vector2 = body.GetWorldPosition(Vector2.Create(_coordinateAxisLineLength / 2, 0)) 
			Local startY:Vector2 = body.GetWorldPosition(Vector2.Create(0, - _coordinateAxisLineLength / 2)) 
			Local endY:Vector2 = body.GetWorldPosition(Vector2.Create(0, _coordinateAxisLineLength / 2)) 
			
			_coordinateAxisLineBrush.Draw(startX, endX) 
			_coordinateAxisLineBrush.Draw(startY, endY) 
		Next
	End Method
	
	Method DrawContacts() 
		Local arbiterList:TArbiterList = _physicsSimulator.GetArbiterList() 
		For Local arbiter:TArbiter = EachIn arbiterLIst
			Local cL:TContactList = arbiter.GetContactList() 
			For Local contact:TContact = EachIn cL
				_contactCircleBrush.Draw(contact.Position) 
			Next
		Next
	End Method
	
	Method DrawPerformancePanel() 
		DrawImage(_performancePanelTexture, _performancePanelPosition.X, _performancePanelPosition.Y) 
		Local pos:Vector2 = Vector2.Create(110, 110) 
		DrawString(Self._updateTotal + _physicsSimulator.UpdateTime, pos) 
		pos.Y:+15
		DrawString(Self._cleanUp + _physicsSimulator.CleanUptime, pos) 
		pos.Y:+15
		DrawString(_broadPhaseCollision + _physicsSimulator.BroadPhaseCollisionTime, pos) 
		pos.Y:+15
		DrawString(_narrowPhaseCollision + _physicsSimulator.NarrowPhaseCollisionTime, pos) 
		pos.Y:+15
		DrawString(_applyForces + _physicsSimulator.ApplyForcesTime, pos) 
		pos.Y:+15
		DrawString(_applyImpulses + _physicsSimulator.ApplyImpulsesTime, pos) 
		pos.Y:+15
		DrawString(_updatePosition + _physicsSimulator.UpdatePositionsTime, pos) 
	End Method
	
	Method DrawGrid()
		Local point:Vector2 = Vector2.Zero()
		Local count:Int = 0
		For Local geom:TGeom = EachIn _physicsSimulator.GetGeomList()
			If geom._grid = Null Then Continue
			count = geom._grid._points.Length
			For Local j:Int = 0 To count - 1
				point = geom.GetWorldPosition(geom._grid._points[j])
				_gridCircleBrush.Draw(point)
			Next
		Next
	End Method
	
	Function DrawString(txt:String, pos:Vector2) 
		DrawText(txt, pos.X, pos.Y) 
	End Function
'#End Region 

	Method JustShowPerformancePanel() 
		Self._enableAABBView = False
		Self._enableContactView = False
		Self._enableCoordinateAxisView = False
		Self._enableEdgeView = False
		Self._enableGridView = False
		Self._enableVerticeView = False
		Self._enableRevoluteJointView = False
		Self._enableSpringView = False
		Self._enablePerformancePanelView = True
	End Method
End Type
